<?php 
    $comCodigo = isset($_GET['com_codigo']) ? $_GET['com_codigo'] : '';
    $cliRucIde = isset($_GET['cli_rucide']) ? $_GET['cli_rucide'] : '';

    if (empty($comCodigo) || empty($cliRucIde)) {
        echo json_encode(['error' => 'Parámetros faltantes'], JSON_UNESCAPED_UNICODE);
        exit;
    }

    require_once('./../database/conn.php');
    $mysql = new connection();
    $conexion = $mysql->getConnection();

    header('Content-Type: application/json; charset=utf-8');

    // $statement = $conexion->prepare("SELECT COUNT(CLI_CODIGO) as count, CLI_CODIGO as cli_cod FROM ven_maecliente WHERE COM_CODIGO = ? AND CLI_RUCIDE = ?");
    $statement = $conexion->prepare("SELECT COUNT(CLI_CODIGO) as count, CLI_CODIGO as cli_cod FROM ven_maecliente WHERE COM_CODIGO = ? AND CLI_RUCIDE LIKE ? LIMIT 1");

    $cliRucIde = $cliRucIde . '%';
    
    $statement->bind_param("ss", $comCodigo, $cliRucIde); 

    $statement->execute(); 

    $resultSet = $statement->get_result();
    $result = $resultSet->fetch_assoc();

    if ($result['count'] > 0) {
        echo json_encode(['result' => true, 'cli' => $result['cli_cod']], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode(['result' => false, 'cli' => null], JSON_UNESCAPED_UNICODE);
    }

    $statement->close();
    $conexion->close();
?>
