<?php 
    $comCodigo = isset($_GET['com_codigo']) ? $_GET['com_codigo'] : '';
    $punCodigo = isset($_GET['pun_codigo']) ? $_GET['pun_codigo'] : '';

    if (empty($comCodigo) || empty($punCodigo)) {
        echo json_encode(['error' => 'Parámetros faltantes'], JSON_UNESCAPED_UNICODE);
        exit;
    }

    require_once('./../database/conn.php');
    $mysql = new connection();
    $conexion = $mysql->getConnection();

    header('Content-Type: application/json; charset=utf-8');

    // SELECT PUN_CODIGO FROM ameliapro_1.mae_puntoemision WHERE COM_CODIGO = '6187' AND PUN_CODIGOPUNTOEMISION = '200';
    $statement = $conexion->prepare("SELECT PUN_CODIGO AS codigo FROM mae_puntoemision WHERE COM_CODIGO = ? AND PUN_CODIGOPUNTOEMISION = ? LIMIT 1");

    $statement->bind_param("ss", $comCodigo, $punCodigo); 

    $statement->execute(); 

    $resultSet = $statement->get_result();
    $result = $resultSet->fetch_assoc();

    if ($result['codigo']) {
        echo json_encode(['result' => true, 'codigo' => $result['codigo']], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode(['result' => false, 'codigo' => null], JSON_UNESCAPED_UNICODE);
    }

    $statement->close();
    $conexion->close();
?>
