// URLS DESARROLLO
const notificacionCorreo = "https://firmasecuador.com:8084";
const sitioWeb = "https://firmasecuador.com";
const amelia = "https://www.amelia.ec:9911";

// URLS PRODUCCION
// const notificacionCorreo = "http://127.0.0.1:4545";
// const sitioWeb = "http://127.0.0.1/admin-firmas";
// const amelia = "http://127.0.0.1:9006";

function display_proveedores(ruc) {
    if (ruc == null) {
        ruc = "NUEVO";
    }
    $.ajax({
        url: "getProveed.php",
        type: "post",
        data: { ruc }
    }).then(function (data) {
        document.getElementById("panelEditar").innerHTML = data
        $("#modalIngresar").modal("show");
        $("#getRuc").click(function () {
            var id = $("#txtRuc").val()
            if (id.length == 10) {
                var direccion = "../../cedula.php"

                $.ajax({
                    data: "GET",
                    url: direccion,
                    data: {
                        id
                    },
                    dataType: "JSOn",


                }).done(function (data) {
                    console.log(data)
                    document.getElementById("txtRazonSocial").value = data.name
                    document.getElementById("txtDireccion").value = data.residence
                });
            } else if (id.length == 13) {

                var direccion = "http://51.158.26.39:3016/site/org.kodhe.rucinfo/q/" + id

                $.ajax({
                    data: "GET",
                    url: direccion,
                    dataType: "JSOn",


                }).done(function (data) {
                    console.log(data)
                    document.getElementById("txtRazonSocial").value = data.RAZON_SOCIAL
                    document.getElementById("txtNombreComercial").value = data.NOMBRE_COMERCIAL
                    document.getElementById("txtDireccion").value = data.DESCRIPCION_PROVINCIA + " " + data.CALLE + " " + data.INTERSECCION + " " + data.NUMERO
                    document.getElementById("txtActividad").value = data.ACTIVIDAD_ECONOMICA
                });
            } else {
                Swal.fire({
                    title: "Documento no valido",
                    icon: "error",
                    position: "center",
                    customClass: {
                        popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                    }
                });
                return false;
            }

        })
    });
}

function mostrarOcultarDiv() {
    var select = document.getElementById("carga");
    var div = document.getElementById("miDiv");
    var email = document.getElementById("miDivEmail");

    if (select.value === "1") {
        div.style.display = "block";  // Mostrar el div
        email.style.display = "block";  // Mostrar el div
    } else {
        div.style.display = "none";   // Ocultar el div
    }
}

function validarArchivo() {
    var input = document.getElementById("firmaA");
    var archivo = input.files[0];
    var allowedExtensions = [".p12", ".pfx", ".rar", ".zip"];

    if (archivo) {
        var archivoNombre = archivo.name;
        var archivoExtension = archivoNombre.substr(archivoNombre.lastIndexOf('.')).toLowerCase();

        if (allowedExtensions.indexOf(archivoExtension) === -1) {
            alert("El archivo seleccionado no es un archivo válido. Por favor, seleccione un archivo válido.");
            input.value = ""; // Limpia el campo de carga de archivos
        }
    }
}

function enviarCorreo() {
    var clave = $("#txtCredencial").val();
    var usuario = $("#nameEmail").val();
    var correo = $("#correoEmail").val();
    var firmaA = $("#firmaA")[0].files[0];

    // Verificar que el archivo se haya capturado correctamente
    if (!firmaA) {
        console.error("No se seleccionó ningún archivo");
        alert("Por favor, seleccione un archivo.");
        return;
    }

    // Convertir el archivo a Base64
    var reader = new FileReader();
    reader.onload = function (e) {
        var base64File = e.target.result.split(',')[1]; // Obtener solo la parte Base64
        // Crear un objeto para enviar los datos
        var formData = {
            clave: clave,
            usuario: usuario,
            correo: correo,
            file1: base64File,
            fileName: firmaA.name,
            fileType: firmaA.type
        };

        // Enviar datos al backend usando AJAX
        $.ajax({
            url: `${notificacionCorreo}/api/firma`,
            type: "POST",
            contentType: "application/json",
            data: JSON.stringify(formData),
            success: function (data) {
                console.log(data);
                alert("Correo Enviado con éxito")
                /*
                Swal.fire({
                    title: "Correo Enviado con éxito",
                    icon: "success"
                });
                */
            },
            error: function (xhr, status, error) {
                console.error("Error al enviar la solicitud:", error);
                
                alert("Error al enviar el correo")
                /*
                Swal.fire({
                    title: "Error al enviar la solicitud",
                    icon: "error",
                    position: "center",
                    customClass: {
                        popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                    }
                });
                */
            }
        });
    };
    reader.readAsDataURL(firmaA);
}

function verificarCliente(comCodigo, cliRucIde) {
    return new Promise((resolve, reject) => {
        $.ajax({
            url: `${sitioWeb}/administracion/portal-firmas/amelia-data/data/getClient.php`,
            type: 'GET',
            data: {
                com_codigo: comCodigo,
                cli_rucide: cliRucIde
            },
            dataType: 'json',
            success: function (response) {
                if (response) {
                    resolve(response);
                } else {
                    resolve(false);
                }
            },
            error: function (xhr, status, error) {
                console.error('Hubo un error en la solicitud:', error);
                reject(error);
            }
        });
    });
}

function obtenerCodigoPuntoEmision(comCodigo, punCodigo) {
    return new Promise((resolve, reject) => {
        $.ajax({
            url: `${sitioWeb}/administracion/portal-firmas/amelia-data/data/getPuntoEmision.php`,
            type: 'GET',
            data: {
                com_codigo: comCodigo,
                pun_codigo: punCodigo
            },
            dataType: 'json',
            success: function (response) {
                if (response) {
                    resolve(response);
                } else {
                    resolve(false);
                }
            },
            error: function (xhr, status, error) {
                console.error('Hubo un error en la solicitud:', error);
                reject(error);
            }
        });
    });
}

function consultarDatosFirma(id) {
    return new Promise((resolve, reject) => {
        $.ajax({
            url: `${sitioWeb}/administracion/portal-firmas/firmas-data/getDataFirma.php`,
            type: 'GET',
            data: {
                id
            },
            dataType: 'json',
            success: function (response) {
                if (response) {
                    resolve(response);
                } else {
                    resolve(false);
                }
            },
            error: function (xhr, status, error) {
                console.error('Hubo un error en la solicitud:', error);
                reject(error);
            }
        });
    });
}

function autorizarFacturaAmelia(jsonData, token) {
    return new Promise((resolve, reject) => {
        $.ajax({
            url: `${amelia}/api/facturaVentas/autorizar`,
            type: 'POST',
            headers: {
                'x-token': token
            },
            contentType: "application/json",
            data: JSON.stringify(jsonData),
            success: function (response) {
                console.log("Response Autorizar:", response);
                if (response) {
                    resolve(response);
                } else {
                    resolve(false);
                }
            },
            error: function (xhr, status, error) {
                console.error('Hubo un error en la solicitud:', error);
                reject(error);
            }
        });
    });
}


function registrarFactura(cliente, quit, datos) {
    const { CEDULA_FIRMA, CORREO_CLIENTE, CORREO_DIS, DIRECCION_CLIENTE, DIREC_DIS, TELEFONO_CLIENTE, NOMBRE_CLIENTE, NOMBRE_DIS, PRECIO, RUC_DIS, COD_DIS, RUC_FIRMA, TELEFONO_DIS, TIEMPO_FIRMA, TIPO_FIRMA,
        COM_CODIGO, PUN_CODIGO, token } = datos

    let cedulaFactura, nombreFactura, correoFactura, telefonoFactura, direccionFactura, tipoIdentificacionFactura = ""

    const cedulaFirmaDetalle = CEDULA_FIRMA || RUC_FIRMA

    console.log("Llegamoss a este punto con estos valores", "COD_DIS", COD_DIS, "PUN_CODIGO", PUN_CODIGO);

    if (COD_DIS == "001727" || PUN_CODIGO == 5464 || PUN_CODIGO == 5645) {
        cedulaFactura = CEDULA_FIRMA ? CEDULA_FIRMA.trim() : '';
        nombreFactura = NOMBRE_CLIENTE ? NOMBRE_CLIENTE.trim() : '';
        correoFactura = CORREO_CLIENTE ? CORREO_CLIENTE.trim() : '';
        telefonoFactura = TELEFONO_CLIENTE ? TELEFONO_CLIENTE.trim() : '';
        direccionFactura = DIRECCION_CLIENTE ? DIRECCION_CLIENTE.trim() : '';
    } else {
        cedulaFactura = RUC_DIS ? RUC_DIS.trim() : '';
        nombreFactura = NOMBRE_DIS ? NOMBRE_DIS.trim() : '';
        correoFactura = CORREO_DIS ? CORREO_DIS.trim() : '';
        telefonoFactura = TELEFONO_DIS ? TELEFONO_DIS.trim() : '';
        direccionFactura = DIREC_DIS ? DIREC_DIS.trim() : '';
    }
    
    console.log("Los valores son: ", {
        cedulaFactura,
        nombreFactura,
        correoFactura,
        telefonoFactura,
        direccionFactura
    });

    const totalCaracteres = cedulaFactura.length;

    if (totalCaracteres == 10) {
        tipoIdentificacionFactura = "1"
    }

    if (totalCaracteres == 13) {
        tipoIdentificacionFactura = "2"
    }

    const SUBTOTAL = Number((PRECIO / 1.15).toFixed(2));
    const VALOR_IVA = Number((PRECIO - SUBTOTAL).toFixed(2));

    console.log("LOS CALCULOS SON:", VALOR_IVA, SUBTOTAL);
    console.log("El token es: ", token);

    const fechaAhora = new Date();

    // Opciones para formatear la fecha y la hora
    const opcionesFecha = {
        timeZone: 'America/Guayaquil',
        year: 'numeric',
        month: '2-digit',
        day: '2-digit',
    };

    // Para la hora, formatearemos manualmente para incluir los milisegundos
    const opcionesHora = {
        timeZone: 'America/Guayaquil',
        hour: '2-digit',
        minute: '2-digit',
        second: '2-digit',
        hour12: false // Usar formato de 24 horas
    };

    // Formatear fecha y hora
    const formatoFecha = new Intl.DateTimeFormat('en-CA', opcionesFecha).format(fechaAhora);
    const formatoHora = new Intl.DateTimeFormat('en-CA', opcionesHora).format(fechaAhora);

    // Obtener los milisegundos
    const milisegundos = fechaAhora.getMilliseconds().toString().padStart(3, '0');

    // Armar la fecha completa en el formato deseado
    const fechaActual = formatoFecha.replace(/\//g, '-') + 'T' + formatoHora.replace(/,/g, ':') + '.' + milisegundos + 'Z';

    console.log("fechaActual: ", fechaActual);

    const jsonData = {
        "COM_CODIGO": COM_CODIGO,
        "FOP_CODIGO": 1,
        "FOP_DIASPLAZO": 0,
        "ENCFAC_ESTADO_FE": "CREADO",
        "SUBTOTAL": SUBTOTAL,
        "ENCFAC_BASEIVA": SUBTOTAL,
        "ENCFAC_BASECERO": 0,
        "ENCFAC_BASENOOBJETOIVA": 0,
        "ENCFAC_BASEEXENTOIVA": 0,
        "ENCFAC_VALORDES": 0,
        "ENCFAC_VALORICE": 0,
        "ENCFAC_IRBPN": 0,
        "ENCFAC_VALORIVA": VALOR_IVA,
        "ENCFAC_TOTAL": PRECIO,
        "ENCFAC_OFFLINE": false,
        "detallesFactura": [
            {
                "COM_CODIGO": COM_CODIGO,
                "precioModificado": 0,
                "activarIva": false,
                "BOD_CODIGO": 1,
                "TAI_CODIGO": 6,
                "ART_CODIGO": 1,
                "DETFAC_CODIGO": 1,
                "DETFAC_CODIGOPRINCIPAL": "001",
                "DETFAC_DESCRIPCION": `Firma Electronica ${TIEMPO_FIRMA} ${TIPO_FIRMA} - ${cedulaFirmaDetalle}`,
                "DETFAC_CANTIDAD": 1,
                "DETFAC_ORDEN": 1,
                "DETFAC_FLAG": 1,
                "DETFAC_PRECIO": SUBTOTAL,
                "resetPrecioPvp": SUBTOTAL,
                "DETFAC_DESCUENTO": 0,
                "TOTAL_DETALLE": SUBTOTAL,
                "DETFAC_TOTAL": SUBTOTAL,
                "reinicioIva": 6,
                "verficarProductoIvaCero": false,
                "DETFAC_IVA": VALOR_IVA,
                "DETFAC_TRIBIVA": "S"
            }
        ],
        "datosAdicionales": [
            {
                "COM_CODIGO": COM_CODIGO,
                "DAA_NOMBRE": "Nombre",
                "DAA_VALOR": nombreFactura
            },
            {
                "COM_CODIGO": COM_CODIGO,
                "DAA_NOMBRE": "Direccion",
                "DAA_VALOR": direccionFactura
            },
            {
                "COM_CODIGO": COM_CODIGO,
                "DAA_NOMBRE": "Teléfono",
                "DAA_VALOR": telefonoFactura
            }
        ],
        "formasPago": [],
        "ENCFAC_BASE12": 0,
        "ENCFAC_BASE8": 0,
        "ENCFAC_BASE15": SUBTOTAL,
        "ENCFAC_BASE5": 0,
        "PUN_CODIGO": PUN_CODIGO, // Variar acorde a la empresa
        "ENCFAC_FECHAEMISION": fechaActual.split('T')[0],
        "ENCFAC_NUMERO": 2,
        "ENCFAC_BASE13": 0,
        "ENCFAC_BASE14": 0,
        "ENCFAC_PORCEIVA": 15,
        "VEN_CODIGO": 13,
        "BOD_CODIGO": 1,
        "USU_CODIGO": 15,
        "ASI_CODIGO": 1,
        "CLIENTE": {
            "CLI_CODIGO": cliente,
            "VEN_CODIGO": 1,
            "CLI_NOMBRE": nombreFactura,
            "CLI_NOMBREC": "",
            "CLI_RUCIDE": cedulaFactura,
            "CLI_TELEFONO1": telefonoFactura,
            "COM_CODIGO": COM_CODIGO,
            "CLI_CORREO": correoFactura,
            "CLI_DIRECCION1": direccionFactura,
            "CLI_FECHACONSULTACATASTRO": null,
            "CLI_USUARIOSERCOP": null,
            "TID_CODIGO": tipoIdentificacionFactura,
            "TIP_CODIGO": 2,
            "CLI_ASESOR": false,
            "GrupoCliente": "Clientes",
            "TipoCliente": "PN No Obligado",
            "Asesor": null,
            "CodigoAsesor": null,
            "FACTURA_SALDO": "0.00",
            "GRU_CODIGO": 1,
            "USU_CODIGO": 1,
            "CLI_FECHACREADO": fechaActual
        },
        "CLI_CODIGO": cliente,
        "ENCFAC_FECHAVENCIMIENTO": fechaActual.split('T')[0],
        "ENCFAC_ESTADO_TP": "CREDITO"
    };

    if (quit) {
        delete jsonData.CLI_CODIGO;
        delete jsonData.CLIENTE.CLI_CODIGO;
    }

    console.log("Los datos a enviar son", jsonData);

    // const token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVU1VfQ09ESUdPIjoxNSwiQ09NX0NPRElHTyI6MTE1MCwiVkVOX0NPRElHTyI6MTMsIlBFUkZJTF9DT0RJR08iOjEsIlBVTl9DT0RJR08iOjEyLCJVU1VfSURFTlRJRklDQUNJT04iOiIyMzAwMjk1ODkyIiwiVVNVX0ZFQ0hBSU5HUkVTTyI6IjIwMjItMTEtMDMiLCJVU1VfQUNUSVZPIjpmYWxzZSwiVVNVX0NPUlJFTyI6ImNvbnRhY3RvLmFkcmlhbmJlY2VycmEudGlAZ21haWwuY29tIiwiRFJCX0NPTlRBRE9SIjpmYWxzZSwiZWlkIjoxMTUwLCJlbXBBY3Rpdm8iOnRydWUsImNpZERyYiI6MTIxMywiaWF0IjoxNzI5NzAwNjI2LCJleHAiOjE3Mjk3MTE0MjZ9.hof7QMW2bjoe8-7nCSGSjr6X1lvaDA-uENL5riavhgk";

    $.ajax({
        url: `${amelia}/api/facturaVentas`,
        type: "POST",
        headers: {
            'x-token': token
        },
        contentType: "application/json",
        data: JSON.stringify(jsonData),
        success: function (response) {
            console.log(response);
            const { COM_CODIGO, ENCFAC_CODIGO } = response;
            if (PUN_CODIGO == 5463 || PUN_CODIGO == 5464 || PUN_CODIGO == 5644 || PUN_CODIGO == 5645) {
                autorizarFacturaAmelia({ COM_CODIGO, ENCFAC_CODIGO}, token)
                .then((respuestaAutorizar) => {
                    console.log("Factura autorizada correctamente:", respuestaAutorizar);
                })
                .catch((error) => {
                    console.error("Error al autorizar la factura:", error);
                });
            }
            
            /*
            if (response.success) {
                Swal.fire({
                    title: "Segunda solicitud exitosa",
                    icon: "success"
                });
            } else {
                Swal.fire({
                    title: "Error en la segunda solicitud",
                    icon: "error",
                    position: "center",
                    customClass: {
                        popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                    }
                });
            }
            */
        },
        error: function (xhr, status, error) {
            console.error(error);

        }
    });
}

// Función para crear el contenido personalizado
function createContent() {
    const div = document.createElement('div');
    div.innerHTML = `
        <select id="empresaSelect" class="swal-content__input">
            <option value="">Seleccione una empresa</option>
            <option value="0">Begroup S.A.S</option>
            <option value="1">Tribufirmas S.A.S</option>
        </select>
    `;
    return div;
}

function verificarEmpresaCodigo(empresaCodigo, distribuidorCodigo) {
    console.log("EJECUTANDO FUNCION: verificarEmpresaCodigo");
    console.log("VALORES", empresaCodigo, distribuidorCodigo);

    if (empresaCodigo === null || empresaCodigo === undefined || empresaCodigo === "") {
        Swal.fire({
            title: 'Seleccione una empresa',
            text: 'Por favor, seleccione una empresa de la lista:',
            content: createContent(),  // Creamos y usamos contenido personalizado
            buttons: {
                cancel: 'Cancelar',
                confirm: 'Confirmar'
            }
        }).then((confirm) => {
            if (confirm) {
                const select = document.getElementById('empresaSelect');
                const empresaSeleccionada = select.value;

                if (!empresaSeleccionada) {
                    swal("Error", "Debe seleccionar una empresa", "error");
                    return;
                }

                const jsonData = {
                    empresaCodigo: empresaSeleccionada,
                    distribuidorCodigo
                };

                fetch(`${sitioWeb}/administracion/portal-firmas/empresa-distribuidor/postEmpresaDistribuidor.php`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(jsonData)
                })
                    .then(response => response.json())
                    .then(data => {
                        swal("Solicitud enviada", `Empresa seleccionada: ${empresaSeleccionada}`, "success");
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        swal("Error", "No se pudo enviar la solicitud. Inténtelo de nuevo.", "error");
                    });
            }
        });
    }
}

function display_prove(ruc) {
    if (ruc == null) {
        ruc = "NUEVO";
    }
    console.log(ruc)
    $.ajax({
        url: "getProveed1.php",
        type: "post",
        data: { ruc }
    }).then(function (data) {
        document.getElementById("panelEditar1").innerHTML = data
        $("#modalIngresar1").modal("show");
        $(".guardarFinalizar").click(function () {
            console.log('hola perraaaa')
            var clave = $("#clave").val()

            console.log(txtclave, clave);

            $.ajax({
                url: "guardarProveedores1.php",
                type: "post",
                data: { clave }
            }).then(function (data) {
                console.log(data)
                if (data == "2") {
                    Swal.fire({
                        title: "Datos guardados con exito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")
                } else if (data == "3") {
                    Swal.fire({
                        title: "Datos actualizados con exito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")
                } else if (data == "1") {
                    alert(data)
                    Swal.fire({
                        title: "Error. Consulte con el proveedor",
                        icon: "error",
                        position: "center",
                        didOpen: (popup) => {
                            // Forzar el z-index del modal de SweetAlert2
                            popup.style.zIndex = '9999';
                        }
                    });

                }
            });
        })


        $(".guardarPendiente").click(function () {
            //   console.log("holi boli");
            var clave = $("#clave").val()
            var usuario = $("#usuario").val()
            document.getElementById("txtTime").value = moment().format('Y-M-D HH:mm:ss')
            var txtTime = $("#txtTime").val()
            var txtComentario = $("#txtComentario").val()
            console.log(clave);
            var telefono1 = $("#telefono1").val()
            var telefonoD = $("#telefonoD").val()
            var nombre1 = $("#nombre1").val()
            var correo1 = $("#correo1").val()
            var duracion1 = $("#duracion1").val()
            $.ajax({
                url: "guardarProveedores1.php",
                type: "post",
                data: { clave, usuario, correo1, duracion1, txtComentario, txtTime, nombre1, telefono1, telefonoD }
            }).then(function (data) {
                console.log(data)
                resp = data.replace(/\s+/g, '')
                if (resp == "2") {
                    // Swal.fire({
                    //     title: "Datos guardados con exito",
                    //     icon: "success"
                    // });
                    alert("Datos guardados con exito")
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")
                } else if (resp == "3") {
                    // Swal.fire({
                    //     title: "Datos actualizados con exito",
                    //     icon: "success"
                    // });
                    
                    alert("Datos guardados con exito")

                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")
                } else if (resp == "1") {
                    alert(resp)
                    
                    alert("Error. Consulte con el proveedor")
                    
                    // Swal.fire({
                    //     title: "Error. Consulte con el proveedor",
                    //     icon: "error",
                    //     position: "center",
                    //     customClass: {
                    //         popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                    //     }
                    // });

                }
            });
        })

        $(".guardarEspera3").click(function () {
            /*
            Swal.fire({
                title: "Procesando...",
                text: "Por favor, espere mientras se realiza el proceso.",
                content: {
                    element: "div",
                    attributes: {
                        innerHTML: `
            <style>
              .spinner {
                margin: 20px auto;
                width: 50px;
                height: 50px;
                border: 5px solid rgba(0, 0, 0, 0.1);
                border-top-color: #000;
                border-radius: 50%;
                animation: spin 1s infinite linear;
              }
              
              @keyframes spin {
                0% {
                  transform: rotate(0deg);
                }
                100% {
                  transform: rotate(360deg);
                }
              }
            </style>
            <div class="spinner"></div>
          `
                    }
                },
                buttons: false,  // Deshabilitar botones
                closeOnClickOutside: false,  // No cerrar al hacer clic fuera
                closeOnEsc: false  // No cerrar al presionar Esc
            });
            */
            //   console.log("holi boli");
            var clave = $("#clave").val()
            var usuario = $("#usuario").val()
            document.getElementById("txtTime").value = moment().format('Y-M-D H:m:s')
            var txtTime = $("#txtTime").val()
            console.log(clave);
            var telefono1 = $("#telefono1").val()
            var telefonoD = $("#telefonoD").val()
            var nombre1 = $("#nombre1").val()
            var correo1 = $("#correo1").val()
            var duracion1 = $("#duracion1").val()
            var recurrencia = $("#recurrencia").val()
            let empresaCodigo = $("#empresaCodigo").val();
            let puntoEmision = $("#ptoEmision").val();
            if (recurrencia === 'null') {
                alert('Seleccione la recurrencia para continuar')
                return;
            }
            console.log(telefono1, telefonoD)

            console.log("puntoEmision", puntoEmision);
            

            if (puntoEmision === 'null') {
                /*
                Swal.fire({
                    title: "Seleccione el punto de emisión para continuar",
                    icon: "error",
                    position: "center",
                    customClass: {
                        popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                    }
                });
                */
                alert("Seleccione el punto de emisión para continuar");
                return;
            }

            $.ajax({
                url: "guardarProveedores3.php",
                type: "post",
                data: { clave, usuario, correo1, duracion1, txtTime, nombre1, telefono1, telefonoD, recurrencia }
            }).then(function (data) {
                const response = data.replace(/\s+/g, '').trim();
                console.log(response);
                if (response == "2") {
                    Swal.fire({
                        title: "Datos guardados con exito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")

                    consultarDatosFirma(clave)
                        .then(respuesta => {
                            dataFirma = respuesta;
                            console.log("Datos del endpoint de firma", respuesta);

                            if (dataFirma.COD_DIS == "001727" || puntoEmision == "201") {
                                identificacionFactura = dataFirma.CEDULA_FIRMA || dataFirma.RUC_FIRMA;
                                console.log("Verificamos los datos si es con cédula",identificacionFactura);
                            } else {
                                identificacionFactura = dataFirma.RUC_DIS.trim();
                            }

                            return obtenerCodigoPuntoEmision(empresaCodigo, puntoEmision);

                        })
                        .then(otroResultado => {
                            console.log("Resultado de otra consulta:", otroResultado);

                            dataFirma.COM_CODIGO = empresaCodigo
                            dataFirma.PUN_CODIGO = otroResultado.codigo

                            // Después de la otra consulta, proceder con verificarCliente
                            return verificarCliente(empresaCodigo, identificacionFactura.trim());
                        })
                        .then(resultado => {
                            console.log("Datos del endpoint", resultado);

                            if (empresaCodigo == "1150") {
                                dataFirma.token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVU1VfQ09ESUdPIjoxNSwiQ09NX0NPRElHTyI6MTE1MCwiVkVOX0NPRElHTyI6MTMsIlBFUkZJTF9DT0RJR08iOjEsIlBVTl9DT0RJR08iOjEyLCJVU1VfSURFTlRJRklDQUNJT04iOiIyMzAwMjk1ODkyIiwiVVNVX0ZFQ0hBSU5HUkVTTyI6IjIwMjItMTEtMDMiLCJVU1VfQUNUSVZPIjpmYWxzZSwiVVNVX0NPUlJFTyI6ImNvbnRhY3RvLmFkcmlhbmJlY2VycmEudGlAZ21haWwuY29tIiwiRFJCX0NPTlRBRE9SIjpmYWxzZSwiZWlkIjoxMTUwLCJlbXBBY3Rpdm8iOnRydWUsImNpZERyYiI6MTIxMywiaWF0IjoxNzMwNzc2MzI1LCJleHAiOjE3Nzk3ODcxMjV9.ecNDz_pGYKaa0v-XtrRMBkk0WBgrbfppckhN4Szgans";
                            } else if (empresaCodigo == "2676") {
                                dataFirma.token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVU1VfQ09ESUdPIjoxLCJDT01fQ09ESUdPIjoyNjc2LCJWRU5fQ09ESUdPIjoxMjYzLCJQRVJGSUxfQ09ESUdPIjoxLCJQVU5fQ09ESUdPIjoxMzI2LCJVU1VfSURFTlRJRklDQUNJT04iOiIyMzkwNjI2NzE0MDAxIiwiVVNVX0ZFQ0hBSU5HUkVTTyI6IjIwMjMtMDctMjQiLCJVU1VfQUNUSVZPIjp0cnVlLCJVU1VfQ09SUkVPIjoiY2VkYWNvbnRAZ21haWwuY29tIiwiRFJCX0NPTlRBRE9SIjpmYWxzZSwiZWlkIjoyNjc2LCJlbXBBY3Rpdm8iOnRydWUsImNpZERyYiI6MTIxMywiaWF0IjoxNzMwNzc2MzgzLCJleHAiOjE3Nzk3ODcxODN9.tnU9IkHbigF7uBvoOdbu8FMatOz4FoM8VBDTcAwTO3Y";
                            }

                            console.log(dataFirma);

                            if (resultado.result) {
                                console.log('Cliente existe:', resultado);
                                registrarFactura(resultado.cli, false, dataFirma);
                            } else {
                                console.log('Cliente no existe', resultado);
                                registrarFactura(resultado.cli, true, dataFirma);
                            }
                        })
                        .catch(error => {
                            console.error('Error en la consulta:', error);
                        });

                } else if (response == "3") {
                    Swal.fire({
                        title: "Datos actualizados con exito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")
                } else if (response == "1") {
                    alert(response)
                    Swal.fire({
                        title: "Error. Consulte con el proveedor",
                        icon: "error",
                        position: "center",
                        customClass: {
                            popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                        }
                    });

                }
            });
        })

        $(".guardarEspera4").click(function () {
            /*
            Swal.fire({
                title: "Procesando...",
                text: "Por favor, espere mientras se realiza el proceso.",
                content: {
                    element: "div",
                    attributes: {
                        innerHTML: `
            <style>
              .spinner {
                margin: 20px auto;
                width: 50px;
                height: 50px;
                border: 5px solid rgba(0, 0, 0, 0.1);
                border-top-color: #000;
                border-radius: 50%;
                animation: spin 1s infinite linear;
              }
              
              @keyframes spin {
                0% {
                  transform: rotate(0deg);
                }
                100% {
                  transform: rotate(360deg);
                }
              }
            </style>
            <div class="spinner"></div>
          `
                    }
                },
                buttons: false,  // Deshabilitar botones
                closeOnClickOutside: false,  // No cerrar al hacer clic fuera
                closeOnEsc: false  // No cerrar al presionar Esc
            });
            */

            let dataFirma = null
            let identificacionFactura = null

            let clave = $("#clave").val();
            let Cre = $("#txtClave").val();
            let nombre1 = $("#nombre1").val();
            let cedula1 = $("#cedula1").val();
            let IDCre = $("#txtIDclave").val();
            let usuario = $("#usuario").val();
            let telefonoD = $("#telefonoD").val();
            let txtTime = moment().format('Y-M-D HH:mm:ss');
            let txtComentario = $("#txtComentario").val();
            let telefono1 = $("#telefono1").val();
            let vigenciaWs = $("#vigenciaWs").val();
            let correoEmail = $("#correoEmail").val();
            let claveFirma = $("#txtCredencial").val();
            let recurrencia = $("#recurrencia").val();
            let empresaCodigo = $("#empresaCodigo").val();
            let puntoEmision = $("#ptoEmision").val();

            
            console.log("puntoEmision", puntoEmision);

            // let distribuidorCodigo = $("#distribuidorCodigo").val();
            let firmaA = $("#firmaA")[0].files[0];

            // verificarEmpresaCodigo(empresaCodigo, distribuidorCodigo)

            let formData = new FormData();
            formData.append("clave", clave);
            formData.append("nombre1", nombre1);
            formData.append("cedula1", cedula1);
            formData.append("Cre", Cre);
            formData.append("IDCre", IDCre);
            formData.append("telefono1", telefono1);
            formData.append("telefonoD", telefonoD);
            formData.append("usuario", usuario);
            formData.append("txtTime", txtTime);
            formData.append("txtComentario", txtComentario);
            formData.append("vigenciaWs", vigenciaWs);
            formData.append("correoEmail", correoEmail);
            formData.append("claveFirma", claveFirma);
            formData.append("recurrencia", recurrencia);

            if (recurrencia === 'null') {
                /*
                Swal.fire({
                    title: "Seleccione la recurrencia para continuar",
                    icon: "error",
                    position: "center",
                    customClass: {
                        popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                    }
                });
                */
                alert("Seleccione la recurrencia para continuar");
                return;
            }

            if (puntoEmision === 'null') {
                /*
                Swal.fire({
                    title: "Seleccione el punto de emisión para continuar",
                    icon: "error",
                    position: "center",
                    customClass: {
                        popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                    }
                });
                */
                alert("Seleccione el punto de emisión para continuar");
                return;
            }

            if (firmaA) {
                // Leer el archivo como Base64 usando FileReader
                let reader = new FileReader();
                reader.onload = function (e) {
                    // Obtener el contenido del archivo en Base64
                    let base64Content = e.target.result.split(',')[1]; // Remover la parte inicial "data:;base64,"
                    let fileType = firmaA.type; // Obtener el tipo MIME del archivo

                    // Añadir el contenido en Base64 y el tipo de archivo a formData
                    formData.append("firmaA", base64Content);
                    formData.append("fileType", fileType);

                    // Realizar la solicitud AJAX después de leer el archivo
                    $.ajax({
                        url: "guardarProveedores4.php",
                        type: "post",
                        data: formData,
                        contentType: false,
                        processData: false
                    }).then(function (data) {
                        const response = data.replace(/\s+/g, '').trim();
                        console.log(response);
                        if (response == "2") {
                            Swal.fire({
                                title: "Datos guardados con exito",
                                icon: "success"
                            });
                            $("#modalIngresar1").modal("hide");
                            $(".table-responsive").load("getProveedores.php");

                            consultarDatosFirma(clave)
                                .then(respuesta => {
                                    dataFirma = respuesta;

                                    if (dataFirma.COD_DIS == "001727" || puntoEmision == "201") {
                                        identificacionFactura = dataFirma.CEDULA_FIRMA || dataFirma.RUC_FIRMA;
                                        console.log("Verificamos los datos si es con cédula",identificacionFactura);
                                    } else {
                                        identificacionFactura = dataFirma.RUC_DIS.trim();
                                    }

                                    return obtenerCodigoPuntoEmision(empresaCodigo, puntoEmision);

                                })
                                .then(responsePunto => {

                                    dataFirma.COM_CODIGO = empresaCodigo
                                    dataFirma.PUN_CODIGO = responsePunto.codigo

                                    // Después de la otra consulta, proceder con verificarCliente
                                    return verificarCliente(empresaCodigo, identificacionFactura.trim());
                                })
                                .then(resultado => {
                                    if (empresaCodigo == "1150") {
                                        dataFirma.token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVU1VfQ09ESUdPIjoxNSwiQ09NX0NPRElHTyI6MTE1MCwiVkVOX0NPRElHTyI6MTMsIlBFUkZJTF9DT0RJR08iOjEsIlBVTl9DT0RJR08iOjEyLCJVU1VfSURFTlRJRklDQUNJT04iOiIyMzAwMjk1ODkyIiwiVVNVX0ZFQ0hBSU5HUkVTTyI6IjIwMjItMTEtMDMiLCJVU1VfQUNUSVZPIjpmYWxzZSwiVVNVX0NPUlJFTyI6ImNvbnRhY3RvLmFkcmlhbmJlY2VycmEudGlAZ21haWwuY29tIiwiRFJCX0NPTlRBRE9SIjpmYWxzZSwiZWlkIjoxMTUwLCJlbXBBY3Rpdm8iOnRydWUsImNpZERyYiI6MTIxMywiaWF0IjoxNzMwNzc2MzI1LCJleHAiOjE3Nzk3ODcxMjV9.ecNDz_pGYKaa0v-XtrRMBkk0WBgrbfppckhN4Szgans";
                                    } else if (empresaCodigo == "2676") {
                                        dataFirma.token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVU1VfQ09ESUdPIjoxLCJDT01fQ09ESUdPIjoyNjc2LCJWRU5fQ09ESUdPIjoxMjYzLCJQRVJGSUxfQ09ESUdPIjoxLCJQVU5fQ09ESUdPIjoxMzI2LCJVU1VfSURFTlRJRklDQUNJT04iOiIyMzkwNjI2NzE0MDAxIiwiVVNVX0ZFQ0hBSU5HUkVTTyI6IjIwMjMtMDctMjQiLCJVU1VfQUNUSVZPIjp0cnVlLCJVU1VfQ09SUkVPIjoiY2VkYWNvbnRAZ21haWwuY29tIiwiRFJCX0NPTlRBRE9SIjpmYWxzZSwiZWlkIjoyNjc2LCJlbXBBY3Rpdm8iOnRydWUsImNpZERyYiI6MTIxMywiaWF0IjoxNzMwNzc2MzgzLCJleHAiOjE3Nzk3ODcxODN9.tnU9IkHbigF7uBvoOdbu8FMatOz4FoM8VBDTcAwTO3Y";
                                    }

                                    if (resultado.result) {
                                        console.log('Cliente existe:', resultado);
                                        registrarFactura(resultado.cli, false, dataFirma);
                                    } else {
                                        console.log('Cliente no existe', resultado);
                                        registrarFactura(resultado.cli, true, dataFirma);
                                    }
                                })
                                .catch(error => {
                                    console.error('Error en la consulta:', error);
                                });

                        } else if (response == "3") {
                            Swal.fire({
                                title: "Datos actualizados con éxito",
                                icon: "success"
                            });
                            $("#modalIngresar1").modal("hide");
                            $(".table-responsive").load("getProveedores.php");
                        } else if (response == "1") {
                            alert(response);
                            Swal.fire({
                                title: "Error. Consulte con el proveedor",
                                icon: "error",
                                position: "center",
                                customClass: {
                                    popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                                }
                            });
                        }
                    });
                };

                // Leer el archivo como una URL de datos (Base64)
                reader.readAsDataURL(firmaA);
            } else {
                // alert("Cargue la firma");
                // return
                // Realizar la solicitud AJAX después de leer el archivo
                $.ajax({
                    url: "guardarProveedores4.php",
                    type: "post",
                    data: formData,
                    contentType: false,
                    processData: false
                }).then(function (data) {
                    const response = data.replace(/\s+/g, '').trim();
                    console.log(response);
                    if (response == "2") {
                        Swal.fire({
                            title: "Datos guardados con exito",
                            icon: "success"
                        });
                        $("#modalIngresar1").modal("hide");
                        $(".table-responsive").load("getProveedores.php");

                        consultarDatosFirma(clave)
                            .then(respuesta => {
                                dataFirma = respuesta;

                                if (dataFirma.COD_DIS == "001727" || puntoEmision == "201") {
                                    identificacionFactura = dataFirma.CEDULA_FIRMA || dataFirma.RUC_FIRMA;
                                    console.log("Verificamos los datos si es con cédula",identificacionFactura);
                                } else {
                                    identificacionFactura = dataFirma.RUC_DIS.trim();
                                }

                                return obtenerCodigoPuntoEmision(empresaCodigo, puntoEmision);

                            })
                            .then(responsePunto => {

                                dataFirma.COM_CODIGO = empresaCodigo
                                dataFirma.PUN_CODIGO = responsePunto.codigo

                                // Después de la otra consulta, proceder con verificarCliente
                                return verificarCliente(empresaCodigo, identificacionFactura.trim());
                            })
                            .then(resultado => {
                                if (empresaCodigo == "1150") {
                                    dataFirma.token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVU1VfQ09ESUdPIjoxNSwiQ09NX0NPRElHTyI6MTE1MCwiVkVOX0NPRElHTyI6MTMsIlBFUkZJTF9DT0RJR08iOjEsIlBVTl9DT0RJR08iOjEyLCJVU1VfSURFTlRJRklDQUNJT04iOiIyMzAwMjk1ODkyIiwiVVNVX0ZFQ0hBSU5HUkVTTyI6IjIwMjItMTEtMDMiLCJVU1VfQUNUSVZPIjpmYWxzZSwiVVNVX0NPUlJFTyI6ImNvbnRhY3RvLmFkcmlhbmJlY2VycmEudGlAZ21haWwuY29tIiwiRFJCX0NPTlRBRE9SIjpmYWxzZSwiZWlkIjoxMTUwLCJlbXBBY3Rpdm8iOnRydWUsImNpZERyYiI6MTIxMywiaWF0IjoxNzMwNzc2MzI1LCJleHAiOjE3Nzk3ODcxMjV9.ecNDz_pGYKaa0v-XtrRMBkk0WBgrbfppckhN4Szgans";
                                } else if (empresaCodigo == "2676") {
                                    dataFirma.token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVU1VfQ09ESUdPIjoxLCJDT01fQ09ESUdPIjoyNjc2LCJWRU5fQ09ESUdPIjoxMjYzLCJQRVJGSUxfQ09ESUdPIjoxLCJQVU5fQ09ESUdPIjoxMzI2LCJVU1VfSURFTlRJRklDQUNJT04iOiIyMzkwNjI2NzE0MDAxIiwiVVNVX0ZFQ0hBSU5HUkVTTyI6IjIwMjMtMDctMjQiLCJVU1VfQUNUSVZPIjp0cnVlLCJVU1VfQ09SUkVPIjoiY2VkYWNvbnRAZ21haWwuY29tIiwiRFJCX0NPTlRBRE9SIjpmYWxzZSwiZWlkIjoyNjc2LCJlbXBBY3Rpdm8iOnRydWUsImNpZERyYiI6MTIxMywiaWF0IjoxNzMwNzc2MzgzLCJleHAiOjE3Nzk3ODcxODN9.tnU9IkHbigF7uBvoOdbu8FMatOz4FoM8VBDTcAwTO3Y";
                                }

                                if (resultado.result) {
                                    console.log('Cliente existe:', resultado);
                                    registrarFactura(resultado.cli, false, dataFirma);
                                } else {
                                    console.log('Cliente no existe', resultado);
                                    registrarFactura(resultado.cli, true, dataFirma);
                                }
                            })
                            .catch(error => {
                                console.error('Error en la consulta:', error);
                            });

                    } else if (response == "3") {
                        Swal.fire({
                            title: "Datos actualizados con éxito",
                            icon: "success"
                        });
                        $("#modalIngresar1").modal("hide");
                        $(".table-responsive").load("getProveedores.php");
                    } else if (response == "1") {
                        alert(response);
                        Swal.fire({
                            title: "Error. Consulte con el proveedor",
                            icon: "error",
                            position: "center",
                            customClass: {
                                popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                            }
                        });
                    }
                });
            }
        });

        $(".guardarEspera").click(function () {
            //   console.log("holi boli");
            /*
            Swal.fire({
                title: "Procesando...",
                text: "Por favor, espere mientras se realiza el proceso.",
                content: {
                    element: "div",
                    attributes: {
                        innerHTML: `
                        <style>
                        .spinner {
                            margin: 20px auto;
                            width: 50px;
                            height: 50px;
                            border: 5px solid rgba(0, 0, 0, 0.1);
                            border-top-color: #000;
                            border-radius: 50%;
                            animation: spin 1s infinite linear;
                        }
                        
                        @keyframes spin {
                            0% {
                            transform: rotate(0deg);
                            }
                            100% {
                            transform: rotate(360deg);
                            }
                        }
                        </style>
                        <div class="spinner"></div>
                    `
                    }
                },
                buttons: false,  // Deshabilitar botones
                closeOnClickOutside: false,  // No cerrar al hacer clic fuera
                closeOnEsc: false  // No cerrar al presionar Esc
            });
            */

            var clave = $("#clave").val()
            var usuario = $("#usuario").val()
            document.getElementById("txtTime").value = moment().format('YYYY-MM-DD H:m:s')
            var txtTime = $("#txtTime").val()
            console.log(clave);
            var telefono1 = $("#telefono1").val()
            var telefonoD = $("#telefonoD").val()
            var nombre1 = $("#nombre1").val()
            var correo1 = $("#correo1").val()
            var duracion1 = $("#duracion1").val()
            var Localizador = $("#txtLocal").val()
            var recurrencia = $("#recurrencia").val()
            
            let empresaCodigo = $("#empresaCodigo").val();
            let puntoEmision = $("#ptoEmision").val();

            console.log("puntoEmision", puntoEmision);

            if (recurrencia === 'null') {
                alert('Seleccione la recurrencia para continuar')
                return;
            }

            if (Localizador == null || Localizador.length == "") {

                alert("El localizador es OBLIGATORIO")

                return false;

            }
            if (puntoEmision === 'null') {
                /*
                Swal.fire({
                    title: "Seleccione el punto de emisión para continuar",
                    icon: "error",
                    position: "center",
                    customClass: {
                        popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                    }
                });
                */
                alert("Seleccione el punto de emisión para continuar");
                return;
            }

            console.log(telefono1, telefonoD, Localizador)
            $.ajax({
                url: "guardarProveedores2.php",
                type: "post",
                data: { clave, usuario, correo1, duracion1, txtTime, nombre1, telefono1, telefonoD, Localizador, recurrencia }
            }).then(function (data) {
                const response = data.replace(/\s+/g, '').trim();
                console.log(response);
                if (response == "2") {
                    Swal.fire({
                        title: "Datos guardados con exito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")

                    consultarDatosFirma(clave)
                        .then(respuesta => {
                            dataFirma = respuesta;
                            console.log("Datos del endpoint de firma", respuesta);

                            if (dataFirma.COD_DIS == "001727" || puntoEmision == "201") {
                                identificacionFactura = dataFirma.CEDULA_FIRMA || dataFirma.RUC_FIRMA;
                                console.log("Verificamos los datos si es con cédula",identificacionFactura);                                
                            } else {
                                identificacionFactura = dataFirma.RUC_DIS.trim();
                            }

                            return obtenerCodigoPuntoEmision(empresaCodigo, puntoEmision);

                        })
                        .then(otroResultado => {
                            console.log("Resultado de otra consulta:", otroResultado);

                            dataFirma.COM_CODIGO = empresaCodigo
                            dataFirma.PUN_CODIGO = otroResultado.codigo

                            // Después de la otra consulta, proceder con verificarCliente
                            return verificarCliente(empresaCodigo, identificacionFactura.trim());
                        })
                        .then(resultado => {
                            console.log("Datos del endpoint", resultado);

                            if (empresaCodigo == "1150") {
                                dataFirma.token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVU1VfQ09ESUdPIjoxNSwiQ09NX0NPRElHTyI6MTE1MCwiVkVOX0NPRElHTyI6MTMsIlBFUkZJTF9DT0RJR08iOjEsIlBVTl9DT0RJR08iOjEyLCJVU1VfSURFTlRJRklDQUNJT04iOiIyMzAwMjk1ODkyIiwiVVNVX0ZFQ0hBSU5HUkVTTyI6IjIwMjItMTEtMDMiLCJVU1VfQUNUSVZPIjpmYWxzZSwiVVNVX0NPUlJFTyI6ImNvbnRhY3RvLmFkcmlhbmJlY2VycmEudGlAZ21haWwuY29tIiwiRFJCX0NPTlRBRE9SIjpmYWxzZSwiZWlkIjoxMTUwLCJlbXBBY3Rpdm8iOnRydWUsImNpZERyYiI6MTIxMywiaWF0IjoxNzMwNzc2MzI1LCJleHAiOjE3Nzk3ODcxMjV9.ecNDz_pGYKaa0v-XtrRMBkk0WBgrbfppckhN4Szgans";
                            } else if (empresaCodigo == "2676") {
                                dataFirma.token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVU1VfQ09ESUdPIjoxLCJDT01fQ09ESUdPIjoyNjc2LCJWRU5fQ09ESUdPIjoxMjYzLCJQRVJGSUxfQ09ESUdPIjoxLCJQVU5fQ09ESUdPIjoxMzI2LCJVU1VfSURFTlRJRklDQUNJT04iOiIyMzkwNjI2NzE0MDAxIiwiVVNVX0ZFQ0hBSU5HUkVTTyI6IjIwMjMtMDctMjQiLCJVU1VfQUNUSVZPIjp0cnVlLCJVU1VfQ09SUkVPIjoiY2VkYWNvbnRAZ21haWwuY29tIiwiRFJCX0NPTlRBRE9SIjpmYWxzZSwiZWlkIjoyNjc2LCJlbXBBY3Rpdm8iOnRydWUsImNpZERyYiI6MTIxMywiaWF0IjoxNzMwNzc2MzgzLCJleHAiOjE3Nzk3ODcxODN9.tnU9IkHbigF7uBvoOdbu8FMatOz4FoM8VBDTcAwTO3Y";
                            }

                            console.log(dataFirma);

                            if (resultado.result) {
                                console.log('Cliente existe:', resultado);
                                registrarFactura(resultado.cli, false, dataFirma);
                            } else {
                                console.log('Cliente no existe', resultado);
                                registrarFactura(resultado.cli, true, dataFirma);
                            }
                        })
                        .catch(error => {
                            console.error('Error en la consulta:', error);
                        });
                } else if (response == "3") {
                    Swal.fire({
                        title: "Datos actualizados con exito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")
                } else if (response == "1") {
                    alert(response)
                    Swal.fire({
                        title: "Error. Consulte con el proveedor",
                        icon: "error",
                        position: "center",
                        customClass: {
                            popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                        }
                    });

                }
            });
        })

        $(".guardarEsperaDistribuidor").click(function () {
            // console.log("holi boli");
            var clave = $("#clave").val();
            var Cre = $("#txtClave").val();
            var nombre1 = $("#nombre1").val();
            var cedula1 = $("#cedula1").val();
            var IDCre = $("#txtIDclave").val();
            var usuario = $("#usuario").val();
            var telefonoD = $("#telefonoD").val();
            var txtTime = moment().format('Y-M-D HH:mm:ss');
            var txtComentario = $("#txtComentario").val();
            var telefono1 = $("#telefono1").val();
            var vigenciaWs = $("#vigenciaWs").val();
            var correoEmail = $("#correoEmail").val();
            var claveFirma = $("#txtCredencial").val();
            var emisor = $("#emisor").val();
            var recurrencia = $("#recurrencia").val();

            if (recurrencia === 'null') {
                alert('Seleccione la recurrencia para continuar')
                return;
            }

            if (emisor === 'null') {
                alert('Seleccione el Emisor para continuar')
                return;
            }
            // Captura el archivo seleccionado
            //   var firmaA = $("#firmaA")[0].files[0];

            var formData = new FormData();
            formData.append("clave", clave);
            formData.append("nombre1", nombre1);
            formData.append("cedula1", cedula1);
            formData.append("Cre", Cre);
            formData.append("IDCre", IDCre);
            formData.append("telefono1", telefono1);
            formData.append("telefonoD", telefonoD);
            formData.append("usuario", usuario);
            formData.append("txtTime", txtTime);
            formData.append("txtComentario", txtComentario);
            formData.append("vigenciaWs", vigenciaWs);
            formData.append("correoEmail", correoEmail);
            formData.append("claveFirma", claveFirma);
            formData.append("emisor", emisor);
            formData.append("recurrencia", recurrencia);

            //   if (firmaA) {
            //       formData.append("firmaA", firmaA);
            //   }

            $.ajax({
                url: "guardarDistribuidor.php",
                type: "post",
                data: formData,
                contentType: false,
                processData: false
            }).then(function (data) {
                console.log(data);
                if (data == "2") {
                    Swal.fire({
                        title: "Datos guardados con exito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php");
                } else if (data == "3") {
                    Swal.fire({
                        title: "Datos actualizados con éxito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php");
                } else if (data == "1") {
                    alert(data);
                    Swal.fire({
                        title: "Error. Consulte con el proveedor",
                        icon: "error",
                        position: "center",
                        customClass: {
                            popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                        }
                    });
                }
            });
        })

        $(".guardar2").click(function () {
            //  console.log("holi boli");

            var clave = $("#clave").val()

            console.log(clave);

            $.ajax({
                url: "guardarProveedores3.php",
                type: "post",
                data: { clave }
            }).then(function (data) {
                console.log(data)
                if (data == "2") {
                    Swal.fire({
                        title: "Datos guardados con exito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")
                } else if (data == "3") {
                    Swal.fire({
                        title: "Datos actualizados con exito",
                        icon: "success"
                    });
                    $("#modalIngresar1").modal("hide");
                    $(".table-responsive").load("getProveedores.php")
                } else if (data == "1") {
                    alert(data)
                    Swal.fire({
                        title: "Error. Consulte con el proveedor",
                        icon: "error",
                        position: "center",
                        customClass: {
                            popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                        }
                    });

                }
            });
        })
    });
}

function upload_image() { //Funcion encargada de enviar el archivo via AJAX
    $(".upload-msg").text('Cargando...');
    // var ruc56 = $("#ruc56").val()
    // console.log(ruc56);
    var inputFileImage = document.getElementById("fileToUpload");
    var file = inputFileImage.files[0];
    var data8 = new FormData();
    data8.append('fileToUpload', file);
    data8.append("ruc56", $("#ruc56").val());

    /*jQuery.each($('#fileToUpload')[0].files, function(i, file) {
        data.append('file'+i, file);
    });*/

    $.ajax({
        url: "upload.php", // Url to which the request is send
        type: "POST", // Type of request to be send, called as method
        data: data8, // Data sent to server, a set of key/value pairs (i.e. form fields and values)
        contentType: false, // The content type used when sending data to the server.
        cache: false, // To unable request pages to be cached
        processData: false, // To send DOMDocument or non processed data file it is set to false
        success: function (data) // A function to be called if request succeeds
        {
            $(".table-responsive").load("getProveedores.php")
            $(".upload-msg").html(data);
            window.setTimeout(function () {
                $(".alert-dismissible").fadeTo(500, 0).slideUp(500, function () {
                    $(this).remove();
                });
            }, 2000);
        }
    });

}

$(".guardarProveedores1").click(function () {
    console.log('hola perraaaa')
    var txtclave = $("#txtclave").val()
    var txtclave2 = $("#txtclave2").val()
    var clave = $("#clave").val()

    console.log(txtclave, clave, txtclave2);

    $.ajax({
        url: "guardarProveedores.php",
        type: "post",
        data: { txtclave, clave, txtclave2 }
    }).then(function (data) {
        console.log(data);
        if (data == "2") {
            console.log(data);
            Swal.fire({
                title: "Datos guardados con exito",
                icon: "success"
            });
            $("#modalIngresar1").modal("hide");
            $(".table-responsive").load("getProveedores.php")
        } else if (data == "3") {
            console.log(data);
            Swal.fire({
                title: "Datos actualizados con exito",
                icon: "success"
            });
            $("#modalIngresar1").modal("hide");
            $(".table-responsive").load("getProveedores.php")
        } else if (data == "1") {
            console.log(data);
            Swal.fire({
                title: "Error. Consulte con el proveedor",
                icon: "error",
                position: "center",
                customClass: {
                    popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                }
            });

        }
    });
})

function eliminar_proveedor(ruc) {

    $.ajax({
        url: "deleteProveed.php",
        type: "post",
        data: { ruc }
    }).then(function (data) {
        if (data == "2") {
            Swal.fire({
                title: "Proveedor eliminado",
                icon: "success"
            });
            $(".table-responsive").load("getProveedores.php")

        } else {
            Swal.fire({
                title: "No se ha podido eliminar",
                icon: "error",
                position: "center",
                customClass: {
                    popup: 'my-custom-popup' // Clase personalizada que puedes definir en tu CSS
                }
            });

        }
    });
}

;
(function () {
    $(".table-responsive").load("getProveedores.php")

    $('.tabla_proovedores').DataTable({
        pageLength: 10,
        responsive: true,
        dom: '<"html5buttons"B>lTfgitp',
        buttons: [
            { extend: 'copy' },
            { extend: 'csv' },
            { extend: 'excel', title: 'ExampleFile' },
            { extend: 'pdf', title: 'ExampleFile' },

            {
                extend: 'print',
                customize: function (win) {
                    $(win.document.body).addClass('white-bg');
                    $(win.document.body).css('font-size', '10px');

                    $(win.document.body).find('table')
                        .addClass('compact')
                        .css('font-size', 'inherit');
                }
            }
        ]

    });

    $('.typeahead_1').typeahead({
        source: function (query, result) {
            $.ajax({
                url: "getCuenta.php",
                data: 'query=' + query,
                dataType: "json",
                type: "POST",
                success: function (data) {
                    result($.map(data, function (item) {
                        return item;
                    }));
                }
            });
        }
    });

})()