<?php
include '../../Connection/conexion.php';
include '../../Connection/config.php';
//$codi = $_POST["codi"];
session_start();
$nivel = $_SESSION['nivel'];
$codDis = $_SESSION['nombre'];
?>
<div class="responsive">
    <table class="table table-striped table-bordered table-hover tabla_proovedores" id="tabla_proovedores">
        <thead>
            <tr>
                <th>Cod</th>
                <th>TIPO</th>
                <th>RUC</th>
                <th>RAZON SOCIAL</th>
                <th>TELEFONO</th>
                <th>ESTADO</th>
                <th>CORREO</th>
                <th>Tipo y duracion</th>
                <th>Emisor</th>
                <th>Hora Ingreso</th>
                <th>ACCIONES</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($nivel == 10) {
                $query = "
                    SELECT 
                        id AS 'id',
                        codUnico AS 'codUnico',
                        codDis AS 'codDis',
                        ruc AS 'ruc',
                        cedula AS 'cedula',
                        razon_social AS 'razon_social',
                        telefono AS 'telefono',
                        (SELECT COUNT(*) AS rep FROM registro1 B WHERE B.telefono1 = A.telefono GROUP BY telefono1) AS rep,
                        (SELECT COUNT(*) AS rep1 FROM registroa B WHERE B.telefono = A.telefono GROUP BY telefono) AS rep1,
                        Estado AS 'Estado',
                        correo AS 'correo',
                        Emisor AS 'Emisor',
                        tipo AS 'tipo',
                        tiempoFirma AS 'tiempoFirma',
                        horaIngreso AS 'horaIngreso',
                        duracion AS 'duracion',
                        (SELECT COUNT(*) AS num FROM registro1 B WHERE B.correo1 = A.correo GROUP BY correo1) AS num,
                        (SELECT COUNT(*) AS num2 FROM registroa B WHERE B.correo = A.correo GROUP BY correo) AS num2,
	                    (SELECT EMPRESA FROM seg_maeusuario WHERE USUNOMBRE = codDis LIMIT 1) AS empresa_distribuidor,
	                    (SELECT USUAPELLIDO FROM seg_maeusuario WHERE USUNOMBRE = codDis LIMIT 1) AS nombre_distribuidor
                    FROM 
                        registroa A 
                    WHERE 
                        Estado = 'En Proceso' 
                        AND codDis = $codDis;
                ";
            } else {
                $query = "
                    SELECT 
                        id AS 'id',
                        codUnico AS 'codUnico',
                        codDis AS 'codDis',
                        ruc AS 'ruc',
                        cedula AS 'cedula',
                        razon_social AS 'razon_social',
                        telefono AS 'telefono',
                        (SELECT COUNT(*) AS rep FROM registro1 B WHERE B.telefono1 = A.telefono GROUP BY telefono1) AS rep,
                        (SELECT COUNT(*) AS rep1 FROM registroa B WHERE B.telefono = A.telefono GROUP BY telefono) AS rep1,
                        Estado AS 'Estado',
                        correo AS 'correo',
                        Emisor AS 'Emisor',
                        tipo AS 'tipo',
                        tiempoFirma AS 'tiempoFirma',
                        horaIngreso AS 'horaIngreso',
                        duracion AS 'duracion',
                        (SELECT COUNT(*) AS num FROM registro1 B WHERE B.correo1 = A.correo GROUP BY correo1) AS num,
                        (SELECT COUNT(*) AS num2 FROM registroa B WHERE B.correo = A.correo GROUP BY correo) AS num2,
	                    (SELECT EMPRESA FROM seg_maeusuario WHERE USUNOMBRE = codDis LIMIT 1) AS empresa_distribuidor,
	                    (SELECT USUAPELLIDO FROM seg_maeusuario WHERE USUNOMBRE = codDis LIMIT 1) AS nombre_distribuidor
                    FROM 
                        registroa A 
                    WHERE 
                        Estado = 'PENDIENTE';
                ";
            }

            $consulta = $pdo->query($query);
            while ($fila = $consulta->fetch()) {
                $codigo = $fila["id"];
                $codigo2 = $fila["codUnico"];
            ?>
                <tr>
                    <td><?php echo $fila["id"]; ?></td>
                    <td><?php echo $fila["codDis"]; ?></td>
                    <td><?php echo $fila["ruc"] . ' ' . $fila["cedula"]; ?></td>
                    <td><?php echo $fila["razon_social"]; ?></td>
                    <td><?php echo $fila["telefono"] . ' reg: ' . $fila["rep"] . ' ' . $fila["rep1"]; ?></td>
                    <td>
                        <?php if ($fila["Estado"] == "nuevo") { ?>
                            <small class="label label-primary"><?php echo $fila["Estado"]; ?></small>
                        <?php } elseif ($fila["Estado"] == "FINALIZADO") { ?>
                            <small class="label label-danger"><?php echo $fila["Estado"]; ?></small>
                        <?php } elseif ($fila["Estado"] == "PENDIENTE") { ?>
                            <small class="label label-success"><?php echo $fila["Estado"]; ?></small>
                        <?php } elseif ($fila["Estado"] == "EN ESPERA") { ?>
                            <small class="label label-warning"><?php echo $fila["Estado"]; ?></small>
                        <?php } else { ?>
                            <small class="label label-secondary"><?php echo $fila["Estado"]; ?></small>
                        <?php } ?>
                    </td>
                    <td><?php echo $fila["correo"] . ' ' . $fila["num2"] . ' ' . $fila["num"]; ?></td>
                    <td><?php echo $fila["duracion"] . ' ' . $fila["tipo"]; ?></td>
                    <td><?php echo $fila["Emisor"]; ?></td>
                    <td><?php echo $fila["horaIngreso"]; ?></td>
                    <td align="center">
                        <div class="btn-group">
                            
                        <?php 
                            // Comprobar si empresa_distribuidor tiene un valor válido
                            if ($fila["empresa_distribuidor"] == NULL || $fila["empresa_distribuidor"] == "" || $fila["empresa_distribuidor"] == "NULL") { ?>
                                <!-- Botón alternativo que abre el modal cuando empresa_distribuidor es null, undefined o "" -->
                                <button class="btn btn-warning" onclick="openModal('<?php echo $fila['codDis']; ?>', '<?php echo $fila['nombre_distribuidor']; ?>')">
                                    <i class="fa fa-building"></i> Asignar Emp. Distri.                                
                                </button>
                            <?php } else { ?>
                                <!-- Botón PDF cuando empresa_distribuidor tiene valor -->
                                <button class="btn btn-secondary editar1" id="editar1" type="button" data-id="<?php echo $fila["id"]; ?>" onclick="return display_prove('<?php echo $fila['id']; ?>')">
                                    <i class="fa fa-file"></i>
                                </button>
                                <form name="form8" id="<?php echo $fila["codUnico"]; ?>" method="post" action="Generarpdf.php">
                                    <input type="hidden" name="txtDo" id="txtDo" value="<?php echo $fila["codUnico"]; ?>">
                                    <button id="b" type="submit" class="btn btn-info">PDF</button>
                                </form>
                            <?php } ?>
                        </div>
                    </td>
                </tr>
            <?php
            }
            ?>
        </tbody>
        <tfoot>
            <tr>
                <th>Cod</th>
                <th>TIPO</th>
                <th>RUC</th>
                <th>RAZON SOCIAL</th>
                <th>TELEFONO</th>
                <th>ESTADO</th>
                <th>CORREO</th>
                <th>Tipo y duracion</th>
                <th>Emisor</th>
                <th>Hora Ingreso</th>
                <th>ACCIONES</th>
            </tr>
        </tfoot>
    </table>
</div>
<script src="../../js/plugins/dataTables/datatables.min.js"></script>
<script src="../../js/plugins/dataTables/dataTables.bootstrap4.min.js"></script>
<script src="js/proveedores_tabla.js"></script>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function openModal(distribuidorCodigo, distribuidorNombre) {
    Swal.fire({
        title: 'Asignar Empresa',
        html: `
            <form id="formAsignarEmpresa">
                <label for="distribuidorNombre">Distribuidor: ${distribuidorNombre}</label>
                <br>
                <label for="empresaCodigo">Seleccione Empresa:</label>
                <select id="empresaCodigo" name="empresaCodigo" class="swal2-input">
                    <option value="1150">Begroup S.A.S</option>
                    <option value="2676">Tribufirmas S.A.S</option>
                </select>
                <input type="hidden" id="distribuidorCodigo" name="distribuidorCodigo" value="${distribuidorCodigo}">
            </form>
        `,
        confirmButtonText: 'Asignar',
        showCancelButton: true,
        preConfirm: () => {
            const empresaCodigo = document.getElementById('empresaCodigo').value;

            const jsonData = {
                empresaCodigo,
                distribuidorCodigo
            };

            console.log(jsonData);            

            return fetch('https://firmasecuador.com/administracion/portal-firmas/empresa-distribuidor/postEmpresaDistribuidor.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(jsonData)
            }).then(response => {
                if (!response.ok) {
                    throw new Error('Error al asignar la empresa');
                }
                return response.json();
            }).catch(error => {
                Swal.showValidationMessage(`Error: ${error}`);
            });
        }
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire('Asignado', 'La empresa se ha asignado exitosamente', 'success');
            window.location.reload();
        }
    });
}
</script>

