<?php
    require_once ('Connection/connection.php');
    $mysql = new connection();
    $conexion = $mysql->getConnection();

    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    $correo = $data['correo'];
    $clave = $data['clave'];
    $id = $data['id'];

    // $correo = "kevin.palma97kap@gmail.com";
    // $clave = "Moodle2020*";
    // $id = 25474;

    $statement = $conexion->prepare("SELECT id FROM registroa WHERE correo = ? AND clave = ? AND id = ? LIMIT 1");
    $statement->bind_param("ssi", $correo, $clave, $id);
    $statement->execute(); 

    if ($resultSet = $statement->get_result()) {
        $registros = $resultSet->fetch_all(MYSQLI_ASSOC);

        if (count($registros) == 1) {
            $idFirma = $registros[0]['id'];
            obtenerFirma($conexion, $idFirma);
        } else {
            http_response_code(404);
            echo json_encode(array("msg" => "Verifique los datos ingresados"));
        }
    } else {
        http_response_code(500);
        echo json_encode(array("msg" => "Error al verificar datos. Intente nuevamente"));
    }

    function guardarArchivo($file) {

        $fileEnc = base64_decode($file);
    
        if ($fileEnc !== false) { // Verificar si la decodificación fue exitosa
            $uniqueFileName = uniqid() . '.p12'; // Generar un nombre único para el archivo
    
            // Ruta donde se guardarán los archivos
            $filePath = './files/' . $uniqueFileName;
    
            // Guardar el archivo en la carpeta "files"
            if (file_put_contents($filePath, $fileEnc)) {
                echo json_encode(array("archivo" => $uniqueFileName));
            } else {
                http_response_code(500);
                // En realidad es un error al guardar el archivo
                echo json_encode(array("msg" => "Error al procesar el archivo"));
            }
        } else {
            http_response_code(500);
            // En realidad es un error al decodificar el archivo base64
            echo json_encode(array("msg" => "Error al procesar el archivo"));
        }
    }

    function obtenerFirma($conexion, $id) {
        $statement2 = $conexion->prepare("SELECT archivo, idcursos FROM firmas WHERE idFirma = ? LIMIT 1");
        $statement2->bind_param("i", $id);
        $statement2->execute();
    
        if ($resultSet2 = $statement2->get_result()) {
            $firmas = $resultSet2->fetch_all(MYSQLI_ASSOC);
    
            if (count($firmas) == 1) {
                $base64Archivo = $firmas[0]['archivo'];
                guardarArchivo($base64Archivo);
            } else {
                http_response_code(500);
                echo json_encode(array("msg" => "Archivo vacío o no existe"));
            }
        } else {
            http_response_code(500);
            echo json_encode(array("msg" => "Error al obtener el archivo. Intente nuevamente"));
        }
    }


    