<?php
include './../../Connection/conexion.php';
include './../../Connection/config.php';

$input = file_get_contents('php://input');
$data = json_decode($input, true);

$punto = $data["puntoEmision"];
$distribuidor = $data["distribuidorCodigo"];

try {
    // Preparar la consulta con parámetros
    $stmt = $pdo->prepare("
        UPDATE 
            `seg_maeusuario`
        SET 
            `PTO_EMISION` = :punto
        WHERE 
            `USUNOMBRE` = :distribuidor
        LIMIT 1
    ");

    $stmt->bindParam(':punto', $punto, PDO::PARAM_INT);
    $stmt->bindParam(':distribuidor', $distribuidor, PDO::PARAM_INT);

    // Ejecutar la query
    $stmt->execute();

    // Verificar si se actualizó alguna fila
    $response = ['success' => $stmt->rowCount() > 0];

    // Devolver los resultados como JSON
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    // En caso de error, mostrar mensaje de error
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
