<?php
include './../../Connection/conexion.php';
include './../../Connection/config.php';

// Obtener el valor del parámetro 'id' del formulario
$id = $_GET["id"];

try {
    // Preparar la consulta con parámetros
    $stmt = $pdo->prepare("
        SELECT 
            FIR.ruc AS RUC_FIRMA, 
            FIR.cedula AS CEDULA_FIRMA, 
            FIR.tipo AS TIPO_FIRMA, 
            FIR.duracion AS TIEMPO_FIRMA, 
            FIR.razon_social AS NOMBRE_CLIENTE, 
            FIR.direccion AS DIRECCION_CLIENTE, 
            FIR.correo AS CORREO_CLIENTE, 
            FIR.telefono AS TELEFONO_CLIENTE,
            FIR.valorC AS PRECIO, 
            DIS.USUNOMBRE AS COD_DIS, 
            DIS.USURUCI AS RUC_DIS, 
            DIS.USUAPELLIDO AS NOMBRE_DIS, 
            DIS.DIRECCION AS DIREC_DIS, 
            DIS.telefono AS TELEFONO_DIS, 
            DIS.correo AS CORREO_DIS
        FROM 
            firmasecuador.registroa AS FIR
        JOIN 
            firmasecuador.seg_maeusuario AS DIS 
        ON 
            FIR.codDis = DIS.USUNOMBRE
        WHERE 
            FIR.id = :id
        LIMIT 1
    ");

    // Vincular el parámetro :id a la variable $id
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    // Ejecutar la consulta
    $stmt->execute();

    // Obtener los resultados como un array asociativo
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Devolver los resultados como JSON
    header('Content-Type: application/json');
    echo json_encode($result, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    // En caso de error, mostrar mensaje de error
    echo 'Error: ' . $e->getMessage();
}
?>
