<?php
include './../../Connection/conexion.php';
include './../../Connection/config.php';

$input = file_get_contents('php://input');
$data = json_decode($input, true);

$factura = $data["numero_factura"];
$codigo = $data["codigo_factura"];
$id = $data["id"];

try {
    // Preparar la sentencia con parámetros
    $stmt = $pdo->prepare("
        UPDATE 
            `registroa`
        SET 
            `codigo_factura` = :codigo, 
            `numero_factura` = :numero
        WHERE 
            `id` = :id
        LIMIT 1
    ");

    $stmt->bindParam(':codigo', $codigo, PDO::PARAM_INT);
    $stmt->bindParam(':numero', $factura, PDO::PARAM_STR);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    // Ejecutar la query
    $stmt->execute();

    // Verificar si se actualizó alguna fila
    $response = ['success' => $stmt->rowCount() > 0];

    // Devolver los resultados como JSON
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    // En caso de error, mostrar mensaje de error
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
